/* 
 * Data.h - Storage for a Mondriaan painting
 *
 * Copyright (C) 1998 J.I. van Hemert
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Author: J.I. van Hemert <jvhemert@cs.leidenuniv.nl>
 *
 * Last Revision: 04-Apr-1999 12:24 by jvhemert
 *
 */

#ifndef Data_H
#define Data_H

#include "Canvas.h"
#include <vector>

class Data
{
	public:

		Data
		()
		{};
		
		Data
		(
			unsigned int _size
		)
		{};
		
		~Data(){};

		// INSERT data structure



		/* Draws a Mondriaan-like image on a canvas.
		 */

			void
		Draw
		(
			Canvas & _canvas
		)
		{
			// INSERT procedure for drawing image on a canvas

			_canvas.DrawHorizontalLine(Coordinates(1,1), Coordinates(3,1), Color::red);
			_canvas.DrawHorizontalLine(Coordinates(1,3), Coordinates(3,3), Color::red);
			_canvas.DrawVerticalLine(Coordinates(3,1), Coordinates(3,3), Color::red);
			_canvas.DrawVerticalLine(Coordinates(1,1), Coordinates(1,3), Color::red);
			_canvas.DrawRectangle(Coordinates(1,1), Coordinates(2,2), Color::yellow);

			_canvas.DrawHorizontalLine(Coordinates(7,7), Coordinates(9,7), Color::red);
			_canvas.DrawHorizontalLine(Coordinates(7,9), Coordinates(9,9), Color::red);
			_canvas.DrawVerticalLine(Coordinates(9,7), Coordinates(9,9), Color::red);
			_canvas.DrawVerticalLine(Coordinates(7,7), Coordinates(7,9), Color::red);
			_canvas.DrawVerticalLine(Coordinates(8,7), Coordinates(8,9), Color::blue);
			_canvas.DrawHorizontalLine(Coordinates(7,8), Coordinates(9,8), Color::yellow);

			_canvas.DrawHorizontalLine(Coordinates(0,4), Coordinates(16,4), Color::black);
			_canvas.DrawHorizontalLine(Coordinates(1,5), Coordinates(15,5), Color::black);
			_canvas.DrawHorizontalLine(Coordinates(2,6), Coordinates(14,6), Color::black);
			_canvas.DrawVerticalLine(Coordinates(15,0), Coordinates(15,16), Color::cyan);
			_canvas.DrawVerticalLine(Coordinates(14,1), Coordinates(14,15), Color::cyan);
			_canvas.DrawVerticalLine(Coordinates(13,2), Coordinates(13,14), Color::cyan);
		} // Draw;

		friend
		ostream &
		operator<<
		(
			ostream & _ostream,
			Data const & _data
		)
		{
			_ostream << "Contents: ";

			return _ostream;
		};

	protected:

	private:

};

#endif // Data_H

// Eof Data.h
