/*  Note: You are free to use whatever license you want.
    Eventually you will be able to edit it within Glade. */

/*  mondriaan
 *  Copyright (C) <YEAR> <AUTHORS>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include "gladesig.h"
#include "gladesrc.h"

GtkWidget*
get_widget                             (GtkWidget       *widget,
                                        gchar           *widget_name)
{
  GtkWidget *found_widget;

  if (widget->parent)
    widget = gtk_widget_get_toplevel (widget);
  found_widget = (GtkWidget*) gtk_object_get_data (GTK_OBJECT (widget),
                                                   widget_name);
  if (!found_widget)
    g_warning ("Widget not found: %s", widget_name);
  return found_widget;
}

/* This is an internally used function to set notebook tab widgets. */
void
set_notebook_tab                       (GtkWidget       *notebook,
                                        gint             page_num,
                                        GtkWidget       *widget)
{
  GtkNotebookPage *page;
  GtkWidget *notebook_page;

  page = (GtkNotebookPage*) g_list_nth (GTK_NOTEBOOK (notebook)->children, page_num)->data;
  notebook_page = page->child;
  gtk_widget_ref (notebook_page);
  gtk_notebook_remove_page (GTK_NOTEBOOK (notebook), page_num);
  gtk_notebook_insert_page (GTK_NOTEBOOK (notebook), notebook_page,
                            widget, page_num);
  gtk_widget_unref (notebook_page);
}

GtkWidget*
create_window5 ()
{
  GtkWidget *window5;
  GtkWidget *vbox6;
  GtkWidget *table3;
  GtkWidget *drawingarea2;
  GtkWidget *hscale1;
  GtkWidget *hscale2;
  GtkWidget *hscale3;
  GtkWidget *hscale4;
  GtkWidget *hscale5;
  GtkWidget *hscale6;
  GtkWidget *hscale7;
  GtkWidget *hscale8;
  GtkWidget *hscale9;
  GtkWidget *drawingarea1;
  GtkWidget *drawingarea9;
  GtkWidget *drawingarea8;
  GtkWidget *drawingarea7;
  GtkWidget *drawingarea4;
  GtkWidget *drawingarea5;
  GtkWidget *drawingarea6;
  GtkWidget *drawingarea3;
  GtkWidget *hbuttonbox7;
  GtkWidget *quit_button;
  GtkWidget *help_button;
  GtkWidget *next_button;
  GtkAcceleratorTable *accelerator_table;
  GtkTooltips *tooltips;

  tooltips = gtk_tooltips_new ();

  window5 = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_object_set_data (GTK_OBJECT (window5), "window5", window5);
  gtk_signal_connect (GTK_OBJECT (window5), "delete_event",
                      GTK_SIGNAL_FUNC (on_window5_delete_event),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (window5), "destroy",
                      GTK_SIGNAL_FUNC (on_window5_destroy),
                      NULL);
  gtk_window_set_title (GTK_WINDOW (window5), "Mondriaan Art by Evolution");
  gtk_window_set_policy (GTK_WINDOW (window5), FALSE, FALSE, FALSE);

  vbox6 = gtk_vbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (window5), "vbox6", vbox6);
  gtk_widget_show (vbox6);
  gtk_container_add (GTK_CONTAINER (window5), vbox6);

  table3 = gtk_table_new (6, 3, FALSE);
  gtk_object_set_data (GTK_OBJECT (window5), "table3", table3);
  gtk_widget_show (table3);
  gtk_box_pack_start (GTK_BOX (vbox6), table3, TRUE, TRUE, 0);
  gtk_container_border_width (GTK_CONTAINER (table3), 15);
  gtk_table_set_row_spacings (GTK_TABLE (table3), 20);
  gtk_table_set_col_spacings (GTK_TABLE (table3), 30);

  drawingarea2 = gtk_drawing_area_new ();
  gtk_object_set_data (GTK_OBJECT (window5), "drawingarea2", drawingarea2);
  gtk_widget_show (drawingarea2);
  gtk_table_attach (GTK_TABLE (table3), drawingarea2, 1, 2, 0, 1,
                    (GtkAttachOptions) GTK_FILL, (GtkAttachOptions) GTK_FILL, 1, 1);
  gtk_widget_set_usize (drawingarea2, 152, 152);
  gtk_tooltips_set_tip (tooltips, drawingarea2, "2", NULL);
  gtk_widget_set_events (drawingarea2, GDK_EXPOSURE_MASK);
  gtk_signal_connect (GTK_OBJECT (drawingarea2), "expose_event",
                      GTK_SIGNAL_FUNC (on_drawingarea2_expose_event),
                      NULL);

  hscale1 = gtk_hscale_new (GTK_ADJUSTMENT (gtk_adjustment_new (0, 0, 10, 1, 0, 0)));
  gtk_object_set_data (GTK_OBJECT (window5), "hscale1", hscale1);
  gtk_widget_show (hscale1);
  gtk_table_attach (GTK_TABLE (table3), hscale1, 0, 1, 1, 2,
                    (GtkAttachOptions) GTK_EXPAND | GTK_FILL, (GtkAttachOptions) GTK_EXPAND | GTK_FILL, 0, 0);
  gtk_widget_set_events (hscale1, GDK_BUTTON_RELEASE_MASK | GDK_KEY_RELEASE_MASK);
  gtk_scale_set_digits (GTK_SCALE (hscale1), 0);

  hscale2 = gtk_hscale_new (GTK_ADJUSTMENT (gtk_adjustment_new (0, 0, 10, 1, 0, 0)));
  gtk_object_set_data (GTK_OBJECT (window5), "hscale2", hscale2);
  gtk_widget_show (hscale2);
  gtk_table_attach (GTK_TABLE (table3), hscale2, 1, 2, 1, 2,
                    (GtkAttachOptions) GTK_EXPAND | GTK_FILL, (GtkAttachOptions) GTK_EXPAND | GTK_FILL, 0, 0);
  gtk_scale_set_digits (GTK_SCALE (hscale2), 0);

  hscale3 = gtk_hscale_new (GTK_ADJUSTMENT (gtk_adjustment_new (0, 0, 10, 1, 0, 0)));
  gtk_object_set_data (GTK_OBJECT (window5), "hscale3", hscale3);
  gtk_widget_show (hscale3);
  gtk_table_attach (GTK_TABLE (table3), hscale3, 2, 3, 1, 2,
                    (GtkAttachOptions) GTK_EXPAND | GTK_FILL, (GtkAttachOptions) GTK_EXPAND | GTK_FILL, 0, 0);
  gtk_scale_set_digits (GTK_SCALE (hscale3), 0);

  hscale4 = gtk_hscale_new (GTK_ADJUSTMENT (gtk_adjustment_new (0, 0, 10, 1, 0, 0)));
  gtk_object_set_data (GTK_OBJECT (window5), "hscale4", hscale4);
  gtk_widget_show (hscale4);
  gtk_table_attach (GTK_TABLE (table3), hscale4, 0, 1, 3, 4,
                    (GtkAttachOptions) GTK_EXPAND | GTK_FILL, (GtkAttachOptions) GTK_EXPAND | GTK_FILL, 0, 0);
  gtk_scale_set_digits (GTK_SCALE (hscale4), 0);

  hscale5 = gtk_hscale_new (GTK_ADJUSTMENT (gtk_adjustment_new (0, 0, 10, 1, 0, 0)));
  gtk_object_set_data (GTK_OBJECT (window5), "hscale5", hscale5);
  gtk_widget_show (hscale5);
  gtk_table_attach (GTK_TABLE (table3), hscale5, 1, 2, 3, 4,
                    (GtkAttachOptions) GTK_EXPAND | GTK_FILL, (GtkAttachOptions) GTK_EXPAND | GTK_FILL, 0, 0);
  gtk_scale_set_digits (GTK_SCALE (hscale5), 0);

  hscale6 = gtk_hscale_new (GTK_ADJUSTMENT (gtk_adjustment_new (0, 0, 10, 1, 0, 0)));
  gtk_object_set_data (GTK_OBJECT (window5), "hscale6", hscale6);
  gtk_widget_show (hscale6);
  gtk_table_attach (GTK_TABLE (table3), hscale6, 2, 3, 3, 4,
                    (GtkAttachOptions) GTK_EXPAND | GTK_FILL, (GtkAttachOptions) GTK_EXPAND | GTK_FILL, 0, 0);
  gtk_scale_set_digits (GTK_SCALE (hscale6), 0);

  hscale7 = gtk_hscale_new (GTK_ADJUSTMENT (gtk_adjustment_new (0, 0, 10, 1, 0, 0)));
  gtk_object_set_data (GTK_OBJECT (window5), "hscale7", hscale7);
  gtk_widget_show (hscale7);
  gtk_table_attach (GTK_TABLE (table3), hscale7, 0, 1, 5, 6,
                    (GtkAttachOptions) GTK_EXPAND | GTK_FILL, (GtkAttachOptions) GTK_EXPAND | GTK_FILL, 0, 0);
  gtk_scale_set_digits (GTK_SCALE (hscale7), 0);

  hscale8 = gtk_hscale_new (GTK_ADJUSTMENT (gtk_adjustment_new (0, 0, 10, 1, 0, 0)));
  gtk_object_set_data (GTK_OBJECT (window5), "hscale8", hscale8);
  gtk_widget_show (hscale8);
  gtk_table_attach (GTK_TABLE (table3), hscale8, 1, 2, 5, 6,
                    (GtkAttachOptions) GTK_EXPAND | GTK_FILL, (GtkAttachOptions) GTK_EXPAND | GTK_FILL, 0, 0);
  gtk_scale_set_digits (GTK_SCALE (hscale8), 0);

  hscale9 = gtk_hscale_new (GTK_ADJUSTMENT (gtk_adjustment_new (0, 0, 10, 1, 0, 0)));
  gtk_object_set_data (GTK_OBJECT (window5), "hscale9", hscale9);
  gtk_widget_show (hscale9);
  gtk_table_attach (GTK_TABLE (table3), hscale9, 2, 3, 5, 6,
                    (GtkAttachOptions) GTK_EXPAND | GTK_FILL, (GtkAttachOptions) GTK_EXPAND | GTK_FILL, 0, 0);
  gtk_scale_set_digits (GTK_SCALE (hscale9), 0);

  drawingarea1 = gtk_drawing_area_new ();
  gtk_object_set_data (GTK_OBJECT (window5), "drawingarea1", drawingarea1);
  gtk_widget_show (drawingarea1);
  gtk_table_attach (GTK_TABLE (table3), drawingarea1, 0, 1, 0, 1,
                    (GtkAttachOptions) GTK_FILL, (GtkAttachOptions) GTK_FILL, 1, 1);
  gtk_widget_set_usize (drawingarea1, 152, 152);
  gtk_widget_set_events (drawingarea1, GDK_EXPOSURE_MASK);
  gtk_signal_connect (GTK_OBJECT (drawingarea1), "expose_event",
                      GTK_SIGNAL_FUNC (on_drawingarea1_expose_event),
                      NULL);

  drawingarea9 = gtk_drawing_area_new ();
  gtk_object_set_data (GTK_OBJECT (window5), "drawingarea9", drawingarea9);
  gtk_widget_show (drawingarea9);
  gtk_table_attach (GTK_TABLE (table3), drawingarea9, 2, 3, 4, 5,
                    (GtkAttachOptions) GTK_FILL, (GtkAttachOptions) GTK_FILL, 1, 1);
  gtk_widget_set_usize (drawingarea9, 152, 152);
  gtk_widget_set_events (drawingarea9, GDK_EXPOSURE_MASK);
  gtk_signal_connect (GTK_OBJECT (drawingarea9), "expose_event",
                      GTK_SIGNAL_FUNC (on_drawingarea9_expose_event),
                      NULL);

  drawingarea8 = gtk_drawing_area_new ();
  gtk_object_set_data (GTK_OBJECT (window5), "drawingarea8", drawingarea8);
  gtk_widget_show (drawingarea8);
  gtk_table_attach (GTK_TABLE (table3), drawingarea8, 1, 2, 4, 5,
                    (GtkAttachOptions) GTK_FILL, (GtkAttachOptions) GTK_FILL, 1, 1);
  gtk_widget_set_usize (drawingarea8, 152, 152);
  gtk_widget_set_events (drawingarea8, GDK_EXPOSURE_MASK);
  gtk_signal_connect (GTK_OBJECT (drawingarea8), "expose_event",
                      GTK_SIGNAL_FUNC (on_drawingarea8_expose_event),
                      NULL);

  drawingarea7 = gtk_drawing_area_new ();
  gtk_object_set_data (GTK_OBJECT (window5), "drawingarea7", drawingarea7);
  gtk_widget_show (drawingarea7);
  gtk_table_attach (GTK_TABLE (table3), drawingarea7, 0, 1, 4, 5,
                    (GtkAttachOptions) GTK_FILL, (GtkAttachOptions) GTK_FILL, 1, 1);
  gtk_widget_set_usize (drawingarea7, 152, 152);
  gtk_widget_set_events (drawingarea7, GDK_EXPOSURE_MASK);
  gtk_signal_connect (GTK_OBJECT (drawingarea7), "expose_event",
                      GTK_SIGNAL_FUNC (on_drawingarea7_expose_event),
                      NULL);

  drawingarea4 = gtk_drawing_area_new ();
  gtk_object_set_data (GTK_OBJECT (window5), "drawingarea4", drawingarea4);
  gtk_widget_show (drawingarea4);
  gtk_table_attach (GTK_TABLE (table3), drawingarea4, 0, 1, 2, 3,
                    (GtkAttachOptions) GTK_FILL, (GtkAttachOptions) GTK_FILL, 1, 1);
  gtk_widget_set_usize (drawingarea4, 152, 152);
  gtk_widget_set_events (drawingarea4, GDK_EXPOSURE_MASK);
  gtk_signal_connect (GTK_OBJECT (drawingarea4), "expose_event",
                      GTK_SIGNAL_FUNC (on_drawingarea4_expose_event),
                      NULL);

  drawingarea5 = gtk_drawing_area_new ();
  gtk_object_set_data (GTK_OBJECT (window5), "drawingarea5", drawingarea5);
  gtk_widget_show (drawingarea5);
  gtk_table_attach (GTK_TABLE (table3), drawingarea5, 1, 2, 2, 3,
                    (GtkAttachOptions) GTK_FILL, (GtkAttachOptions) GTK_FILL, 1, 1);
  gtk_widget_set_usize (drawingarea5, 152, 152);
  gtk_widget_set_events (drawingarea5, GDK_EXPOSURE_MASK);
  gtk_signal_connect (GTK_OBJECT (drawingarea5), "expose_event",
                      GTK_SIGNAL_FUNC (on_drawingarea5_expose_event),
                      NULL);

  drawingarea6 = gtk_drawing_area_new ();
  gtk_object_set_data (GTK_OBJECT (window5), "drawingarea6", drawingarea6);
  gtk_widget_show (drawingarea6);
  gtk_table_attach (GTK_TABLE (table3), drawingarea6, 2, 3, 2, 3,
                    (GtkAttachOptions) GTK_FILL, (GtkAttachOptions) GTK_FILL, 1, 1);
  gtk_widget_set_usize (drawingarea6, 152, 152);
  gtk_widget_set_events (drawingarea6, GDK_EXPOSURE_MASK);
  gtk_signal_connect (GTK_OBJECT (drawingarea6), "expose_event",
                      GTK_SIGNAL_FUNC (on_drawingarea6_expose_event),
                      NULL);

  drawingarea3 = gtk_drawing_area_new ();
  gtk_object_set_data (GTK_OBJECT (window5), "drawingarea3", drawingarea3);
  gtk_widget_show (drawingarea3);
  gtk_table_attach (GTK_TABLE (table3), drawingarea3, 2, 3, 0, 1,
                    (GtkAttachOptions) GTK_FILL, (GtkAttachOptions) GTK_FILL, 1, 1);
  gtk_widget_set_usize (drawingarea3, 152, 152);
  gtk_widget_set_events (drawingarea3, GDK_EXPOSURE_MASK);
  gtk_signal_connect (GTK_OBJECT (drawingarea3), "expose_event",
                      GTK_SIGNAL_FUNC (on_drawingarea3_expose_event),
                      NULL);

  hbuttonbox7 = gtk_hbutton_box_new ();
  gtk_object_set_data (GTK_OBJECT (window5), "hbuttonbox7", hbuttonbox7);
  gtk_widget_show (hbuttonbox7);
  gtk_box_pack_start (GTK_BOX (vbox6), hbuttonbox7, FALSE, TRUE, 11);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbuttonbox7), GTK_BUTTONBOX_SPREAD);

  quit_button = gtk_button_new_with_label ("Quit");
  gtk_object_set_data (GTK_OBJECT (window5), "quit_button", quit_button);
  gtk_widget_show (quit_button);
  gtk_container_add (GTK_CONTAINER (hbuttonbox7), quit_button);
  gtk_signal_connect (GTK_OBJECT (quit_button), "clicked",
                      GTK_SIGNAL_FUNC (on_quit_button_clicked),
                      NULL);
  accelerator_table = gtk_accelerator_table_new ();
  gtk_window_add_accelerator_table (GTK_WINDOW (window5), accelerator_table);
  gtk_widget_install_accelerator (quit_button, accelerator_table, "clicked",
                                  GDK_Q, 0);

  help_button = gtk_button_new_with_label ("Help");
  gtk_object_set_data (GTK_OBJECT (window5), "help_button", help_button);
  gtk_widget_show (help_button);
  gtk_container_add (GTK_CONTAINER (hbuttonbox7), help_button);
  gtk_signal_connect (GTK_OBJECT (help_button), "clicked",
                      GTK_SIGNAL_FUNC (on_help_button_clicked),
                      NULL);
  gtk_widget_install_accelerator (help_button, accelerator_table, "clicked",
                                  GDK_h, 0);

  next_button = gtk_button_new_with_label ("Next");
  gtk_object_set_data (GTK_OBJECT (window5), "next_button", next_button);
  gtk_widget_show (next_button);
  gtk_container_add (GTK_CONTAINER (hbuttonbox7), next_button);
  gtk_widget_grab_focus (next_button);
  gtk_signal_connect (GTK_OBJECT (next_button), "clicked",
                      GTK_SIGNAL_FUNC (on_next_button_clicked),
                      NULL);
  gtk_widget_install_accelerator (next_button, accelerator_table, "clicked",
                                  GDK_n, 0);

  return window5;
}

GtkWidget*
create_quit_popup ()
{
  GtkWidget *quit_popup;
  GtkWidget *dialog_vbox1;
  GtkWidget *quit_label;
  GtkWidget *dialog_action_area1;
  GtkWidget *hbuttonbox8;
  GtkWidget *quit_button_yes;
  GtkWidget *quit_button_no;
  GtkAcceleratorTable *accelerator_table;

  quit_popup = gtk_dialog_new ();
  gtk_object_set_data (GTK_OBJECT (quit_popup), "quit_popup", quit_popup);
  GTK_WINDOW (quit_popup)->type = GTK_WINDOW_DIALOG;
  gtk_window_set_title (GTK_WINDOW (quit_popup), "Quit?");
  gtk_window_position (GTK_WINDOW (quit_popup), GTK_WIN_POS_MOUSE);
  gtk_window_set_policy (GTK_WINDOW (quit_popup), FALSE, FALSE, FALSE);

  dialog_vbox1 = GTK_DIALOG (quit_popup)->vbox;
  gtk_object_set_data (GTK_OBJECT (quit_popup), "dialog_vbox1", dialog_vbox1);
  gtk_widget_show (dialog_vbox1);

  quit_label = gtk_label_new ("Are you sure?");
  gtk_object_set_data (GTK_OBJECT (quit_popup), "quit_label", quit_label);
  gtk_widget_show (quit_label);
  gtk_box_pack_start (GTK_BOX (dialog_vbox1), quit_label, TRUE, TRUE, 0);
  gtk_misc_set_padding (GTK_MISC (quit_label), 0, 20);

  dialog_action_area1 = GTK_DIALOG (quit_popup)->action_area;
  gtk_object_set_data (GTK_OBJECT (quit_popup), "dialog_action_area1", dialog_action_area1);
  gtk_widget_show (dialog_action_area1);
  gtk_container_border_width (GTK_CONTAINER (dialog_action_area1), 10);

  hbuttonbox8 = gtk_hbutton_box_new ();
  gtk_object_set_data (GTK_OBJECT (quit_popup), "hbuttonbox8", hbuttonbox8);
  gtk_widget_show (hbuttonbox8);
  gtk_box_pack_start (GTK_BOX (dialog_action_area1), hbuttonbox8, TRUE, TRUE, 0);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbuttonbox8), GTK_BUTTONBOX_SPREAD);

  quit_button_yes = gtk_button_new_with_label ("Yes");
  gtk_object_set_data (GTK_OBJECT (quit_popup), "quit_button_yes", quit_button_yes);
  gtk_widget_show (quit_button_yes);
  gtk_container_add (GTK_CONTAINER (hbuttonbox8), quit_button_yes);
  gtk_widget_grab_focus (quit_button_yes);
  gtk_signal_connect (GTK_OBJECT (quit_button_yes), "clicked",
                      GTK_SIGNAL_FUNC (on_quit_button_yes_clicked),
                      NULL);
  accelerator_table = gtk_accelerator_table_new ();
  gtk_window_add_accelerator_table (GTK_WINDOW (quit_popup), accelerator_table);
  gtk_widget_install_accelerator (quit_button_yes, accelerator_table, "clicked",
                                  GDK_y, 0);
  gtk_widget_install_accelerator (quit_button_yes, accelerator_table, "clicked",
                                  GDK_Y, 0);

  quit_button_no = gtk_button_new_with_label ("No");
  gtk_object_set_data (GTK_OBJECT (quit_popup), "quit_button_no", quit_button_no);
  gtk_widget_show (quit_button_no);
  gtk_container_add (GTK_CONTAINER (hbuttonbox8), quit_button_no);
  gtk_signal_connect (GTK_OBJECT (quit_button_no), "clicked",
                      GTK_SIGNAL_FUNC (on_quit_button_no_clicked),
                      NULL);
  gtk_widget_install_accelerator (quit_button_no, accelerator_table, "clicked",
                                  GDK_n, 0);
  gtk_widget_install_accelerator (quit_button_no, accelerator_table, "clicked",
                                  GDK_N, 0);

  return quit_popup;
}

GtkWidget*
create_help_dialog ()
{
  GtkWidget *help_dialog;
  GtkWidget *dialog_vbox2;
  GtkWidget *text1;
  GtkWidget *dialog_action_area2;
  GtkWidget *hbuttonbox9;
  GtkWidget *help_done_button;
  GtkWidget *mondriaan_info_button;
  GtkAcceleratorTable *accelerator_table;

  help_dialog = gtk_dialog_new ();
  gtk_object_set_data (GTK_OBJECT (help_dialog), "help_dialog", help_dialog);
  gtk_widget_set_usize (help_dialog, 400, 500);
  gtk_container_border_width (GTK_CONTAINER (help_dialog), 10);
  GTK_WINDOW (help_dialog)->type = GTK_WINDOW_DIALOG;
  gtk_window_set_title (GTK_WINDOW (help_dialog), "Help");
  gtk_window_position (GTK_WINDOW (help_dialog), GTK_WIN_POS_CENTER);
  gtk_window_set_policy (GTK_WINDOW (help_dialog), FALSE, FALSE, FALSE);

  dialog_vbox2 = GTK_DIALOG (help_dialog)->vbox;
  gtk_object_set_data (GTK_OBJECT (help_dialog), "dialog_vbox2", dialog_vbox2);
  gtk_widget_show (dialog_vbox2);

  text1 = gtk_text_new (NULL, NULL);
  gtk_object_set_data (GTK_OBJECT (help_dialog), "text1", text1);
  gtk_widget_show (text1);
  gtk_box_pack_start (GTK_BOX (dialog_vbox2), text1, TRUE, TRUE, 0);
  gtk_widget_set_usize (text1, -1, 145);
  gtk_widget_realize (text1);
  gtk_text_insert (GTK_TEXT (text1), NULL, NULL, NULL,
                   "\n MONDRIAAN ART BY EVOLUTION\n\n Version 1.0.1 - 1999/04/04\n\n This program generates images resembling art of the famous\n painter Piet Mondriaan. It does this using Evolutionary\n Computation.\n\n The program presents you with nine images, you can rate these\n images by assigning a number using the slider beneath each\n image. A higher number shows you like the image more. By\n pressing the next button the program generates new images\n for you to rate. And so on.\n\n The images are all built using some structure and drawing\n procedure, both hidden from the user. Just like reproduction\n in nature, these structures are involved in crossover and\n mutation. By crossing two images from the current set of images\n we get two new images. These are first mutated randomly before\n the new set is put on the screen. You play one part of the role\n of nature: selection. By giving images you think are more\n Mondriaan like or more attractive higher grades you determine\n which images have more chance of breeding offspring. This\n process converges to a set of images that are more or less\n what you want them to look like.\n\n Happy painting.\n\n Copyright 1999 (C) J.I. van Hemert", 1164);

  dialog_action_area2 = GTK_DIALOG (help_dialog)->action_area;
  gtk_object_set_data (GTK_OBJECT (help_dialog), "dialog_action_area2", dialog_action_area2);
  gtk_widget_show (dialog_action_area2);
  gtk_container_border_width (GTK_CONTAINER (dialog_action_area2), 10);

  hbuttonbox9 = gtk_hbutton_box_new ();
  gtk_object_set_data (GTK_OBJECT (help_dialog), "hbuttonbox9", hbuttonbox9);
  gtk_widget_show (hbuttonbox9);
  gtk_box_pack_start (GTK_BOX (dialog_action_area2), hbuttonbox9, TRUE, TRUE, 0);

  help_done_button = gtk_button_new_with_label ("Done");
  gtk_object_set_data (GTK_OBJECT (help_dialog), "help_done_button", help_done_button);
  gtk_widget_show (help_done_button);
  gtk_container_add (GTK_CONTAINER (hbuttonbox9), help_done_button);
  gtk_widget_grab_focus (help_done_button);
  gtk_signal_connect (GTK_OBJECT (help_done_button), "clicked",
                      GTK_SIGNAL_FUNC (on_help_done_button_clicked),
                      NULL);
  accelerator_table = gtk_accelerator_table_new ();
  gtk_window_add_accelerator_table (GTK_WINDOW (help_dialog), accelerator_table);
  gtk_widget_install_accelerator (help_done_button, accelerator_table, "clicked",
                                  GDK_d, 0);

  mondriaan_info_button = gtk_button_new_with_label ("More...");
  gtk_object_set_data (GTK_OBJECT (help_dialog), "mondriaan_info_button", mondriaan_info_button);
  gtk_widget_show (mondriaan_info_button);
  gtk_container_add (GTK_CONTAINER (hbuttonbox9), mondriaan_info_button);
  gtk_signal_connect (GTK_OBJECT (mondriaan_info_button), "clicked",
                      GTK_SIGNAL_FUNC (on_mondriaan_info_button_clicked),
                      NULL);
  gtk_widget_install_accelerator (mondriaan_info_button, accelerator_table, "clicked",
                                  GDK_m, 0);

  return help_dialog;
}

GtkWidget*
create_mondriaan_info_dialog ()
{
  GtkWidget *mondriaan_info_dialog;
  GtkWidget *dialog_vbox4;
  GtkWidget *text3;
  GtkWidget *dialog_action_area4;
  GtkWidget *hbuttonbox11;
  GtkWidget *mondriaan_done_button;
  GtkAcceleratorTable *accelerator_table;

  mondriaan_info_dialog = gtk_dialog_new ();
  gtk_object_set_data (GTK_OBJECT (mondriaan_info_dialog), "mondriaan_info_dialog", mondriaan_info_dialog);
  gtk_widget_set_usize (mondriaan_info_dialog, 400, 500);
  gtk_container_border_width (GTK_CONTAINER (mondriaan_info_dialog), 10);
  GTK_WINDOW (mondriaan_info_dialog)->type = GTK_WINDOW_DIALOG;
  gtk_window_set_title (GTK_WINDOW (mondriaan_info_dialog), "Mondriaan");
  gtk_window_position (GTK_WINDOW (mondriaan_info_dialog), GTK_WIN_POS_CENTER);
  gtk_window_set_policy (GTK_WINDOW (mondriaan_info_dialog), FALSE, FALSE, FALSE);

  dialog_vbox4 = GTK_DIALOG (mondriaan_info_dialog)->vbox;
  gtk_object_set_data (GTK_OBJECT (mondriaan_info_dialog), "dialog_vbox4", dialog_vbox4);
  gtk_widget_show (dialog_vbox4);

  text3 = gtk_text_new (NULL, NULL);
  gtk_object_set_data (GTK_OBJECT (mondriaan_info_dialog), "text3", text3);
  gtk_widget_show (text3);
  gtk_box_pack_start (GTK_BOX (dialog_vbox4), text3, TRUE, TRUE, 0);
  gtk_widget_realize (text3);
  gtk_text_insert (GTK_TEXT (text3), NULL, NULL, NULL,
                   "\nMONDRIAAN\n\n (Pieter Cornelis Mondriaan 1872-1944)\n\n In the early 1900s many artists tried various abstract ways\n of representing reality. Mondriaan went beyond them. In his\n final compositions he avoided any suggestion of reproducing\n the material world. Instead using horizontal and vertical\n black lines that outline blocks of pure white, red, blue or\n yellow, he expressed his conception of ultimate harmony and\n equilibrium. Mondriaan was born on March 7, 1872 in\n Amersfoort, The Netherlands. He studied at the Amsterdam\n Academy from 1892 to 1895 then began painting on his own.\n Most of his early works were landscapes. In 1909 he began a\n series of paintings of trees in which he developed an\n increasingly abstract style.  He moved to Paris, about 1912,\n where he was influenced by the cubist painters. During World\n War I, Mondriaan painted in The Netherlands. There he helped\n found De Stijl a magazine of the arts that influenced\n European painting, architecture, and design. He also began\n to formulate his own aesthetic theories. His style, and its\n underlying artistic principles, he called neoplasticism.\n The later paintings, which date from 1920 until his death,\n have simple titles, such as \"Composition in Red, Yellow and\n Blue\" painted in 1926, and \"Composition in White, Black and\n Red\" (1936).", 1317);

  dialog_action_area4 = GTK_DIALOG (mondriaan_info_dialog)->action_area;
  gtk_object_set_data (GTK_OBJECT (mondriaan_info_dialog), "dialog_action_area4", dialog_action_area4);
  gtk_widget_show (dialog_action_area4);
  gtk_container_border_width (GTK_CONTAINER (dialog_action_area4), 10);

  hbuttonbox11 = gtk_hbutton_box_new ();
  gtk_object_set_data (GTK_OBJECT (mondriaan_info_dialog), "hbuttonbox11", hbuttonbox11);
  gtk_widget_show (hbuttonbox11);
  gtk_box_pack_start (GTK_BOX (dialog_action_area4), hbuttonbox11, TRUE, TRUE, 0);

  mondriaan_done_button = gtk_button_new_with_label ("Done");
  gtk_object_set_data (GTK_OBJECT (mondriaan_info_dialog), "mondriaan_done_button", mondriaan_done_button);
  gtk_widget_show (mondriaan_done_button);
  gtk_container_add (GTK_CONTAINER (hbuttonbox11), mondriaan_done_button);
  gtk_widget_grab_focus (mondriaan_done_button);
  gtk_signal_connect (GTK_OBJECT (mondriaan_done_button), "clicked",
                      GTK_SIGNAL_FUNC (on_mondriaan_done_button_clicked),
                      NULL);
  accelerator_table = gtk_accelerator_table_new ();
  gtk_window_add_accelerator_table (GTK_WINDOW (mondriaan_info_dialog), accelerator_table);
  gtk_widget_install_accelerator (mondriaan_done_button, accelerator_table, "clicked",
                                  GDK_d, 0);

  return mondriaan_info_dialog;
}

