/* 
 * draw.c - Drawing functions for Gtk objects.
 *
 * Copyright (C) 1998 J.I. van Hemert
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Author: J.I. van Hemert <jvhemert@cs.leidenuniv.nl>
 *
 * Last Revision: 10-Mar-1999 21:58 by jvhemert
 *
 */

#include "draw.h"

static GtkWidget * global_widget;

void
set_global_widget (GtkWidget *widget)
{
	global_widget = widget;
}


/* Draw a rectangle on the screen */
void
draw_draw_rectangle (
				GdkPixmap *pixmap, 
				short int x1, 
				short int y1, 
				short int x2, 
				short int y2,
				short int red,
				short int green,
				short int blue
				)
{
  GdkRectangle update_rect;

  GdkColor *color;
  /*GtkWidget *widget;*/
  GdkGC *gc;

  /* first, create a GC to draw on */
  gc = gdk_gc_new(global_widget->window);

  /* find proper dimensions for rectangle */
  /*gdk_window_get_size(widget->window, &width, &height);*/

  /* the color we want to use */
  color = (GdkColor *)malloc(sizeof(GdkColor));
  
  /* red, green, and blue are passed values, indicating the RGB triple
   * of the color we want to draw. Note that the values of the RGB components
   * within the GdkColor are taken from 0 to 65535, not 0 to 255.
   */
  color->red = red * (65535/255);
  color->green = green * (65535/255);
  color->blue = blue * (65535/255);
  
  /* the pixel value indicates the index in the colormap of the color.
   * it is simply a combination of the RGB values we set earlier
   */
  color->pixel = (gulong)(red*65536 + green*256 + blue);

  /* However, the pixel valule is only truly valid on 24-bit (TrueColor)
   * displays. Therefore, this call is required so that GDK and X can
   * give us the closest color available in the colormap
   */
  gdk_color_alloc(gtk_widget_get_colormap(global_widget), color);

  /* set the foreground to our color */
  gdk_gc_set_foreground(gc, color);
  
  /* draw the rectangle */
  /*gdk_draw_rectangle(widget->window, gc, 1, 0, 0, width, height);*/

  update_rect.x = x1;
  update_rect.y = y1;
  update_rect.width = x2 - x1;
  update_rect.height = y2 - y1;

  gdk_draw_rectangle (pixmap,
		  gc,
                      /*widget->style->black_gc,*/
                      TRUE,
                      update_rect.x, update_rect.y,
                      update_rect.width, update_rect.height);
  /*gtk_widget_draw (global_widget, &update_rect);*/
  /*gtk_widget_draw(global_widget, NULL);*/
  free(color);
  gdk_gc_destroy(gc);
}


void
draw_draw_line (
				GdkPixmap *pixmap, 
				int x1, 
				int y1, 
				int x2, 
				int y2,
				short int red,
				short int green,
				short int blue
				)
{
  /*gdk_draw_line(pixmap, global_widget->style->black_gc, x1, y1, x2, y2);
  gtk_widget_draw(global_widget, NULL);*/

  GdkColor *color;
  GdkGC *gc;

  /* first, create a GC to draw on */
  gc = gdk_gc_new(global_widget->window);

  /* the color we want to use */
  color = (GdkColor *)malloc(sizeof(GdkColor));
  
  /* red, green, and blue are passed values, indicating the RGB triple
   * of the color we want to draw. Note that the values of the RGB components
   * within the GdkColor are taken from 0 to 65535, not 0 to 255.
   */
  color->red = red * (65535/255);
  color->green = green * (65535/255);
  color->blue = blue * (65535/255);
  
  /* the pixel value indicates the index in the colormap of the color.
   * it is simply a combination of the RGB values we set earlier
   */
  color->pixel = (gulong)(red*65536 + green*256 + blue);

  /* However, the pixel valule is only truly valid on 24-bit (TrueColor)
   * displays. Therefore, this call is required so that GDK and X can
   * give us the closest color available in the colormap
   */
  gdk_color_alloc(gtk_widget_get_colormap(global_widget), color);

  /* set the foreground to our color */
  gdk_gc_set_foreground(gc, color);
  
  gdk_draw_line(pixmap, gc, x1, y1, x2, y2);
  /*gtk_widget_draw(global_widget, NULL);*/
  free(color);
  gdk_gc_destroy(gc);
}


void
draw_draw_screen()
{
  gtk_widget_draw(global_widget, NULL);
}
