/* 
 * main.cc - main file for the Mondriaan project.
 *
 * Copyright (C) 1998 J.I. van Hemert
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Author: J.I. van Hemert <jvhemert@cs.leidenuniv.nl>
 *
 * Last Revision: 10-Mar-1999 21:53 by jvhemert
 *
 */


#include "main.h"

#include "ui/gladesrc.h"
#include "ui/gladesig.h"

Mondriaan * mondriaan;

void
mondriaan_goto_next_generation()
{
	try
	{
		mondriaan->GotoNextGeneration();
	}
	catch (Error e)
	{
		 e.Handle();
	}
}

void
mondriaan_restart()
{
	try
	{
		delete mondriaan;
		Configuration configuration("config");
		mondriaan = new Mondriaan(configuration);
	}
	catch (Error e)
	{
		 e.Handle();
	}
}


void
mondriaan_clean_before_terminate()
{
	try
	{
		delete mondriaan;
	}
	catch (Error e)
	{
		 e.Handle();
	}
}

int
main
(
 	int argc,
	char * argv []
)
{

	try
	{
		ui_configure(argc, argv);

		Configuration configuration("mondriaanrc");

#ifdef DEBUG
		cerr << "[Configuration]\n{\n" << configuration << "}\n";
#endif

		mondriaan = new Mondriaan(configuration);

		ui_main();

	}
	catch (Error e)
	{
		 e.Handle();
	}
	

	return 0;

} // main

// Eof main.cc
