/*
 * Random.cc - Simple random-generator.
 *
 * Part of the Library for Evolutionary Algorithm Programming.
 *
 * Copyright (C) 1998 J.I. van Hemert
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Author: J.I. van Hemert
 * Last Revision: 10-Mar-1999 21:56 by jvhemert
 *
 */

#ifndef Random_h
#define Random_h

#include <stdlib.h>

template <class T>
class Random
{
	public:

		Random
		(
			unsigned int _seed
		)
		:
			seed(_seed)
		{
			state = new char[128];

			initstate(seed, state, 128);

		} // Random


		virtual ~Random()
		{
			delete [] state;

		} // ~Random


		T const &
		operator() () const;

		T const &
		operator()
		(
			T const & _lowerbound,
			T const & _upperbound
		) const;

		virtual unsigned int GetSeed ()
		{
			return seed;
		};

		virtual void ReSeed
		(
			unsigned int _seed
		)
		{
			seed = _seed;

			srandom(seed);
		};

	protected:

	private:

		unsigned int seed;

		mutable T randomnumber;

		mutable char * state;

}; // Random



template <class T>
T const &
Random<T>::operator() () const
{
	randomnumber = (T) random();
	return randomnumber;

} // operator()




template <class T>
T const &
Random<T>::operator()
(
 	T const & _lowerbound,
	T const & _upperbound
) const
{
	randomnumber = _lowerbound + (T) ((_upperbound - _lowerbound) * (double) random() / (RAND_MAX));

	return randomnumber;

} // operator()



#endif // Random_H
