/* 
 * Population.h - population template.
 *
 * Copyright (C) 1998 J.I. van Hemert
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Author: J.I. van Hemert <jvhemert@cs.leidenuniv.nl>
 *
 * Last Revision: 10-Mar-1999 21:56 by jvhemert
 *
 */

#ifndef Population_H
#define Population_H

#include <vector>
#include <algo.h>

#include "Individual.h"
#include "Initialization.h"
#include "Evaluate.h"

template <class F, class D>
class Population
{
	public:

		Population
		(
			Initialization<D> const & _initialization,
			Evaluate<F, D> const & _evaluate,
			unsigned int _size
		)
		:
			pool(0)
		{
			for (unsigned int i = 0; i < _size; ++i)
			{
				Individual<F, D> individual(_initialization(), 21);
				_evaluate(individual);
				pool.push_back(individual);
			}
		};
	


		~Population()
		{ pool.clear();};


		unsigned int 
		GetSize() const
		{
			return pool.size();
		};


		Individual<F, D> const &
		GetConstIndividual
		(
			unsigned int _position
		) const
		{
			 return pool[_position];
		};


		Individual<F, D> & 
		GetIndividual
		(
			unsigned int _position
		)
		{
			 return pool[_position];
		};


		vector<Individual<F, D> > &
		Pool()
		{
			return pool;
		}
		
		Population<F, D> &
		operator=
		(
			Population<F, D> const & _population
		)
		{
			if (&_population != this)
			{
				pool = _population.pool;
			}

			return *this;
		};

		
		Individual<F, D> const &
		GetBestIndividual() const
		{

			vector<Individual<F, D> >::const_iterator ci = max_element(pool.begin(), pool.end());
			return *ci;
		};
		
			
		friend
		ostream & 
		operator<<
		(
			ostream & _ostream,
			Population<F, D> const & _population
		)
		{
			for (vector<Individual<F, D> >::const_iterator pi = _population.pool.begin(); pi != _population.pool.end(); ++pi)
			{
				_ostream << (*pi) << endl;
			}
			//copy (_population.pool.begin(),_population.pool.end(),ostream_iterator<Individual**>(_ostream, "\n"));


			return _ostream;
		};


	protected:

	private:

		vector<Individual<F, D> > pool;

}; // Population

#endif // Population_H

// Eof Population.h
