/* 
 * Evaluate.h - evaluates the 'all-ones' problem. IT IS NOT USED IN MONDRIAN.
 *
 * Copyright (C) 1998 J.I. van Hemert
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Author: J.I. van Hemert <jvhemert@cs.leidenuniv.nl>
 *
 * Last Revision: 10-Mar-1999 21:55 by jvhemert
 *
 */

#ifndef Evaluate_H
#define Evaluate_H

#include <algo.h>

template <class F, class D>
class Evaluate
{
	public:

		Evaluate
		()
		:
			NumberOfFitnessEvaluations(0)
		{};

		~Evaluate(){};

		void
		operator()
		(
			Individual<F, D> & _individual
		) const
		{
			// TODO: evaluate an individual

			//_individual.fitness = count(_individual.data.contents.begin(),_individual.data.contents.end(), 1);

#ifdef DEBUG
			cerr << "[Evaluate::() ]" << endl << _individual << endl;
#endif

			NumberOfFitnessEvaluations++;
		};

		unsigned long int
		GetNumberOfFitnessEvaluations() 
		{
			return NumberOfFitnessEvaluations;
		};

	protected:

	private:
		
		mutable unsigned long int NumberOfFitnessEvaluations;

}; // Evaluate


#endif // Evaluate_H

// Eof Evaluate.h
