/* 
 * Crossover.h - A simple one-point crossover for a vector.
 *
 * Copyright (C) 1998 J.I. van Hemert
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Author: J.I. van Hemert <jvhemert@cs.leidenuniv.nl>
 *
 * Last Revision: 10-Mar-1999 21:54 by jvhemert
 *
 */

#ifndef Crossover_H
#define Crossover_H

#include <list>
#include <algo.h>

#include "Individual.h"
#include "Data.h"

template <class F, class D>
class Crossover
{
	public:

		Crossover
		(
			Random<unsigned int> const & _random
		)
		:
			random(_random)
		{};

		~Crossover(){};

		list<Individual<F, D> >
		operator()
		(
			Individual<F, D> const & _parent1,
			Individual<F, D> const & _parent2
		) const
		{
			unsigned int cp;

			D data1(_parent1.GetData().contents.size());
			D data2(_parent2.GetData().contents.size());

			// Fill in two children from two parents
			if (random(0, 2) == 0)
			{			
				cp = random(0, _parent1.GetData().contents.size());

				// Crossover contents.
				for (unsigned int i = 0; i < _parent1.GetData().contents.size(); ++i)
				{
					if (i < cp)
					{
						 data1.contents[i] = _parent1.GetData().contents[i];
						 data2.contents[i] = _parent2.GetData().contents[i];
					}
					else
					{
						 
						 data1.contents[i] = _parent2.GetData().contents[i];
						 data2.contents[i] = _parent1.GetData().contents[i];
					}
				}
				data1.colors = _parent1.GetData().colors;
				data2.colors = _parent2.GetData().colors;
			}
			else
			{			
				cp = random(0, _parent1.GetData().colors.size());

				// Crossover colors.
				for (unsigned int i = 0; i < _parent1.GetData().colors.size(); ++i)
				{
					if (i < cp)
					{
						 data1.colors[i] = _parent1.GetData().colors[i];
						 data2.colors[i] = _parent2.GetData().colors[i];
					}
					else
					{
						 
						 data1.colors[i] = _parent2.GetData().colors[i];
						 data2.colors[i] = _parent1.GetData().colors[i];
					}
				}
				data1.contents = _parent1.GetData().contents;
				data2.contents = _parent2.GetData().contents;
			}

#ifdef DEBUG
			cerr << "[Crossover::() (Parents & Crossoverpoint & Children)]" << endl << _parent1 << endl << _parent2 << endl << "Crossoverpoint: " << cp << endl;
#endif

			Individual<F, D> child1(data1);
			Individual<F, D> child2(data2);

			list<Individual<F, D> > children;
			children.push_back(child1);
			children.push_back(child2);

#ifdef DEBUG
			copy(children.begin(), children.end(), ostream_iterator<Individual<F, D> >(cerr, "\n"));
#endif
			return children;
		};

	protected:

	private:

		Random<unsigned int> const & random;

}; // Crossover

#endif // Crossover_H

// Eof Crossover.h
