/* 
 * Configuration.cc - 
 *
 * Copyright (C) 1998 J.I. van Hemert
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Author: J.I. van Hemert <jvhemert@cs.leidenuniv.nl>
 *
 * Last Revision: 08-Feb-1999 20:04 by jvhemert
 *
 */

#include "Configuration.h"

#include <fstream.h>
//#include <iostream.h>
#include <string>

Configuration::Configuration
(
	string const & _filename
)
{
	ifstream configfile(_filename.c_str());

	if (!configfile)
	{
		throw Error(string("Could not open configuration file \"") + _filename + string ("\""));
	}
	else
	{	
		while (! configfile.eof())
		{
			char * item = new char [100];
			configfile >> item;

			if (! configfile.eof())
			{
				 
				char * value = new char [100];
				configfile >> value;

				//DEBUG cerr << item << " := " << value << endl;

				items[item] = value;

				//DEBUG cerr << item << " ?= " << items[item]  << endl;

			}
			else
			{
				 delete item;
			}
		}

		configfile.close();
	}
	

} // Configuration



// Eof Configuration.cc
