/* 
 * Initialization.h - initialization of a bitvector
 *
 * Copyright (C) 1998 J.I. van Hemert
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Author: J.I. van Hemert <jvhemert@cs.leidenuniv.nl>
 *
 * Last Revision: 13-Mar-1999 16:58 by jvhemert
 *
 */

#ifndef Initialization_H
#define Initialization_H

#include "Individual.h"
#include "Configuration.h"
#include "Random.h"
#include "Data.h"

template <class D>
class Initialization
{
	public:

		Initialization
		(
			Random<unsigned int> const & _random,
			Configuration const & _configuration,
			unsigned long int _size
		)
		:
			random(_random),
			configuration(_configuration),
			size(_size)
		{};

		~Initialization(){};

		D const 
		operator()
		(
		) const
		{
			D r;

			// INSERT Return a new initialized data object.

			return r;
		};


	protected:

	private:

		Random<unsigned int> const & random;

		Configuration const & configuration;

		unsigned long int size;

}; // Initialization

#endif // Initialization_H

// Eof Initialization.h
