/* 
 * Crossover.h - A simple one-point crossover for a vector.
 *
 * Copyright (C) 1998 J.I. van Hemert
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Author: J.I. van Hemert <jvhemert@cs.leidenuniv.nl>
 *
 * Last Revision: 10-Mar-1999 21:54 by jvhemert
 *
 */

#ifndef Crossover_H
#define Crossover_H

#include <list>
#include <algo.h>

#include "Individual.h"
#include "Data.h"

template <class F, class D>
class Crossover
{
	public:

		Crossover
		(
			Random<unsigned int> const & _random
		)
		:
			random(_random)
		{};

		~Crossover(){};

		list<Individual<F, D> >
		operator()
		(
			Individual<F, D> const & _parent1,
			Individual<F, D> const & _parent2
		) const
		{
			D data1;
			D data2;

			// INSERT Construct two children from two parents (fill in data1 and data2 using data from parents)

#ifdef DEBUG
			cerr << "[Crossover::() (Parents & Children)]" << endl << _parent1 << endl << _parent2 << endl;
#endif
 
			Individual<F, D> child1(data1);
			Individual<F, D> child2(data2);

			list<Individual<F, D> > children;
			children.push_back(child1);
			children.push_back(child2);

#ifdef DEBUG
			copy(children.begin(), children.end(), ostream_iterator<Individual<F, D> >(cerr, "\n"));
#endif
			return children;
		};

	protected:

	private:

		Random<unsigned int> const & random;

}; // Crossover

#endif // Crossover_H

// Eof Crossover.h
