/*  Note: You are free to use whatever license you want.
    Eventually you will be able to edit it within Glade. */

/*  Mondriaan
 *  Copyright (C) 1999 J.I. van Hemert
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <gtk/gtk.h>
#include "draw.h"
#include "gladesrc.h"
#include "gladesig.h"

GdkPixmap *pixmaps[NUMBER_OF_CANVAS] = {NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL};


GtkWidget *window5;

/*void fake() {
	char *a[0];
	 ui_main(0,a);
}*/

void
ui_configure (int argc, char *argv[])
{

  gtk_set_locale ();
  gtk_init (&argc, &argv);

  /*
   * The following code was added by Glade to create one of each component
   * (except popup menus), just so that you see something after building
   * the project. Delete any components that you don't want shown initially.
   */
  window5 = create_window5 ();
  gtk_widget_show (window5);

  for (unsigned int i = 0; i < NUMBER_OF_CANVAS; ++i)
  {
		 init_pixmap(i + 1, &(pixmaps[i]));
  }

  set_global_widget(window5);
}


void
ui_main ()
{
  gtk_main ();
}


GtkWidget *quit_popup;
GtkWidget *help_popup;
GtkWidget *mondriaan_info_dialog;

void
on_quit_button_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{

	quit_popup = create_quit_popup ();
	gtk_widget_show(quit_popup);
}


void
on_window5_destroy                     (GtkObject       *object,
                                        gpointer         user_data)
{
	mondriaan_clean_before_terminate();
	gtk_widget_destroy(window5);
	gtk_main_quit();

}

void
on_quit_button_yes_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
	gtk_main_quit();

}


void
on_quit_button_no_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
	gtk_widget_destroy(quit_popup);
}




gboolean
on_drawingarea1_expose_event          (GtkWidget       *widget,
                                        GdkEventExpose  *event,
                                        gpointer         user_data)
{
	gdk_draw_pixmap(widget->window,
                         widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
                         pixmaps[0],
                         event->area.x, event->area.y,
                         event->area.x, event->area.y,
                         event->area.width, event->area.height);


  return FALSE;
}

void
on_next_button_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
	mondriaan_goto_next_generation();
}




gboolean
on_window5_delete_event                (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
	quit_popup = create_quit_popup ();
	gtk_widget_show(quit_popup);

  return TRUE;
}


gboolean
on_drawingarea2_expose_event           (GtkWidget       *widget,
                                        GdkEventExpose  *event,
                                        gpointer         user_data)
{

	gdk_draw_pixmap(widget->window,
                         widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
                         pixmaps[1],
                         event->area.x, event->area.y,
                         event->area.x, event->area.y,
                         event->area.width, event->area.height);

  return FALSE;
}


unsigned int
ui_get_hscale_value					(unsigned int hscale)
{
	char name [10];
  sprintf(name, "hscale%i", hscale);
  return (unsigned int) GTK_HSCALE(get_widget(window5, name))->scale.range.adjustment->value;
}

void
ui_set_hscale_value					(unsigned int hscale,
									unsigned int value)
{
	char name [10];
  sprintf(name, "hscale%i", hscale);
  gtk_adjustment_set_value(GTK_HSCALE(get_widget(window5, name))->scale.range.adjustment, value);
}

void
init_pixmap(
		unsigned int drawingarea,
		GdkPixmap **pixmap)
{
	char name [15];
	  GtkWidget * widget;

	if (*pixmap)
		gdk_pixmap_unref(*pixmap);

	  sprintf(name, "drawingarea%i", drawingarea);

	  widget = get_widget(window5, name);

	*pixmap = gdk_pixmap_new(widget->window,
                         widget->allocation.width,
                         widget->allocation.height,
                         -1);

	gdk_draw_rectangle (*pixmap,
                     widget->style->white_gc,
                     TRUE,
                     0, 0,
                     widget->allocation.width,
                     widget->allocation.height);
}


gboolean
on_drawingarea3_expose_event           (GtkWidget       *widget,
                                        GdkEventExpose  *event,
                                        gpointer         user_data)
{

	gdk_draw_pixmap(widget->window,
                         widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
                         pixmaps[2],
                         event->area.x, event->area.y,
                         event->area.x, event->area.y,
                         event->area.width, event->area.height);

  return FALSE;
}


gboolean
on_drawingarea8_expose_event           (GtkWidget       *widget,
                                        GdkEventExpose  *event,
                                        gpointer         user_data)
{

	gdk_draw_pixmap(widget->window,
                         widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
                         pixmaps[7],
                         event->area.x, event->area.y,
                         event->area.x, event->area.y,
                         event->area.width, event->area.height);

  return FALSE;
}


gboolean
on_drawingarea5_expose_event           (GtkWidget       *widget,
                                        GdkEventExpose  *event,
                                        gpointer         user_data)
{

	gdk_draw_pixmap(widget->window,
                         widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
                         pixmaps[4],
                         event->area.x, event->area.y,
                         event->area.x, event->area.y,
                         event->area.width, event->area.height);

  return FALSE;
}


gboolean
on_drawingarea6_expose_event           (GtkWidget       *widget,
                                        GdkEventExpose  *event,
                                        gpointer         user_data)
{

	gdk_draw_pixmap(widget->window,
                         widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
                         pixmaps[5],
                         event->area.x, event->area.y,
                         event->area.x, event->area.y,
                         event->area.width, event->area.height);

  return FALSE;
}


gboolean
on_drawingarea9_expose_event           (GtkWidget       *widget,
                                        GdkEventExpose  *event,
                                        gpointer         user_data)
{

	gdk_draw_pixmap(widget->window,
                         widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
                         pixmaps[8],
                         event->area.x, event->area.y,
                         event->area.x, event->area.y,
                         event->area.width, event->area.height);

  return FALSE;
}


gboolean
on_drawingarea7_expose_event           (GtkWidget       *widget,
                                        GdkEventExpose  *event,
                                        gpointer         user_data)
{

	gdk_draw_pixmap(widget->window,
                         widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
                         pixmaps[6],
                         event->area.x, event->area.y,
                         event->area.x, event->area.y,
                         event->area.width, event->area.height);

  return FALSE;
}


gboolean
on_drawingarea4_expose_event           (GtkWidget       *widget,
                                        GdkEventExpose  *event,
                                        gpointer         user_data)
{

	gdk_draw_pixmap(widget->window,
                         widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
                         pixmaps[3],
                         event->area.x, event->area.y,
                         event->area.x, event->area.y,
                         event->area.width, event->area.height);

  return FALSE;
}



void
on_help_button_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{

	help_popup = create_help_dialog ();
	gtk_widget_show(help_popup);
}


void
on_help_done_button_clicked            (GtkButton       *button,
                                        gpointer         user_data)
{
	gtk_widget_destroy(help_popup);

}



void
on_mondriaan_info_button_clicked        (GtkButton       *button,
                                        gpointer         user_data)
{
	mondriaan_info_dialog = create_mondriaan_info_dialog ();
	gtk_widget_show(mondriaan_info_dialog);
}


void
on_mondriaan_done_button_clicked        (GtkButton       *button,
                                        gpointer         user_data)
{
	gtk_widget_destroy(mondriaan_info_dialog);
}

