/* 
 * draw.h - Drawing functions for Gtk objects.
 *
 * Copyright (C) 1998 J.I. van Hemert
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Author: J.I. van Hemert <jvhemert@cs.leidenuniv.nl>
 *
 * Last Revision: 10-Mar-1999 21:58 by jvhemert
 *
 */


#include <gtk/gtk.h>

#ifndef draw_H
#define draw_H

void
draw_draw_screen();

void
set_global_widget (GtkWidget *widget);

void
draw_draw_rectangle (
				GdkPixmap *pixmap, 
				short int x, 
				short int y, 
				short int width, 
				short int height,
				short int red,
				short int green,
				short int blue
);

void
draw_draw_line (
				GdkPixmap *pixmap, 
				int x1, 
				int y1, 
				int x2, 
				int y2,
				short int red,
				short int green,
				short int blue
				);

#endif
