/* 
 * SurvivorsSelection.h - Given a population and offspring, builds a new
 * population using the generational model.
 *
 * Copyright (C) 1998 J.I. van Hemert
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Author: J.I. van Hemert <jvhemert@cs.leidenuniv.nl>
 *
 * Last Revision: 10-Mar-1999 21:57 by jvhemert
 *
 */

#ifndef SurvivorsSelection_H
#define SurvivorsSelection_H

#include <list>

#include "Individual.h"
#include "Population.h"

template <class F, class D>
class SurvivorsSelection
{
	public:

		SurvivorsSelection(){};

		~SurvivorsSelection(){};

		void
		operator()
		(
			Population<F, D> & _population,
			list<Individual<F, D> > const & _offspring
		)
		{
			unsigned int i = 0;
			for (list<Individual<F, D> >::const_iterator oi = _offspring.begin(); oi != _offspring.end(); ++oi,++i)
			{
				 _population.GetIndividual(i) = *oi;
			}
		};

	protected:

	private:

}; // SurvivorsSelection

#endif // SurvivorsSelection_H

// Eof SurvivorsSelection.h
