/* 
 * Reproduction.h - Reproduction produces a list of offspring from a
 * population.
 *
 * Copyright (C) 1998 J.I. van Hemert
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Author: J.I. van Hemert <jvhemert@cs.leidenuniv.nl>
 *
 * Last Revision: 10-Mar-1999 21:57 by jvhemert
 *
 */

#ifndef Reproduction_H
#define Reproduction_H

#include <list>

#include "Crossover.h"
#include "Mutation.h"
#include "Evaluate.h"
#include "ParentSelection.h"

#include "Individual.h"

template <class F, class D>
class Reproduction
{
	public:

		Reproduction
		(
			Crossover<F, D> const & _crossover,
			Mutation<F, D> const & _mutation,
			Evaluate<F, D> const & _evaluate
		)
		:
			crossover(_crossover),
			mutation(_mutation),
			evaluate(_evaluate)
		{
		};

		~Reproduction(){};

		list<Individual<F,D> >
		operator()
		(
		 	ParentSelection<F, D> const & _parentselection
		) const
		{

			ParentSelection<F, D>::const_iterator parentiterator(_parentselection);

			list<Individual<F,D> > offspring;

			while (! parentiterator.End())
			{
				{
					list<Individual<F, D> > children;

					Individual<F, D> const & parent1 = parentiterator++;
					if (parentiterator.End())
					{
						Individual<F, D> child(parent1.GetData());

						children.push_back(child);
					}
					else
					{
						Individual<F, D> const & parent2 = parentiterator++;
						children = crossover(parent1, parent2);
					}

					//list<Individual<F,D> > children = crossover(parentiterator++, parentiterator++);

					for (list<Individual<F,D> >::iterator ci = children.begin(); ci != children.end(); ++ci)
					{
						 mutation(*ci);
						 //evaluate(*ci);
					}

					offspring.merge(children);
				}
			}

			return offspring;
		};


	protected:

	private:

		Crossover<F, D> const & crossover;

		Mutation<F, D> const & mutation;

		Evaluate<F, D> const & evaluate;

}; // Reproduction

#endif // Reproduction_H

// Eof Reproduction.h
