/* 
 * Mutation.h - Simple n-point mutation on a vector.
 *
 * Copyright (C) 1998 J.I. van Hemert
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Author: J.I. van Hemert <jvhemert@cs.leidenuniv.nl>
 *
 * Last Revision: 13-Mar-1999 16:55 by jvhemert
 *
 */

#ifndef Mutation_H
#define Mutation_H

#include "Individual.h"
#include "Configuration.h"

template <class F, class D>
class Mutation
{
	public:

		Mutation
		(
			Random<unsigned int> const & _random,
			Configuration const & _configuration
		)
		:
			random(_random),
			configuration(_configuration)
		{};

		~Mutation(){};

		void
		operator()
		(
			Individual<F, D> & _individual
		) const
		{

#ifdef DEBUG
			cerr << "[Mutation::() (Before)]" << endl << _individual << endl;
#endif

			// INSERT mutation operator that works on one individual

#ifdef DEBUG
			cerr << "[Mutation::() (After)]" << endl << _individual << endl;
#endif
		};

	protected:

	private:

		Random<unsigned int> const & random;

		Configuration const & configuration;

}; // Mutation

#endif // Mutation_H

// Eof Mutation.h
