/* 
 * Mondriaan.h - Holds everything for the EA for Mondriaan art.
 *
 * Copyright (C) 1998 J.I. van Hemert
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Author: J.I. van Hemert <jvhemert@cs.leidenuniv.nl>
 *
 * Last Revision: 13-Mar-1999 17:22 by jvhemert
 *
 */

#ifndef Mondriaan_H
#define Mondriaan_H

#include <list>

#include "EA.h"
#include "Configuration.h"
#include "Canvas.h"

class Mondriaan
{
	public:

		Mondriaan
		(
			Configuration const & _configuration
		);

		void
		GotoNextGeneration();

		~Mondriaan();

	protected:

	private:

		Configuration const & configuration;

		Random<unsigned int> random;

		Evaluate<unsigned int ,Data> evaluate;

		Initialization<Data> initialization;

		EA<unsigned int, Data> ea;

		ParentSelection<unsigned int, Data> parentselection;

		Crossover<unsigned int, Data> crossover;
		Mutation<unsigned int, Data> mutation;
		Reproduction<unsigned int ,Data> reproduction;

		SurvivorsSelection<unsigned int, Data> survivorsselection;

		list<Canvas *> screen;

}; // Mondriaan

#endif // Mondriaan_H

// Eof Mondriaan.h
