/* 
 * Mondriaan.cc - Mondriaan art using evolutionary algorithms
 *
 * Copyright (C) 1998 J.I. van Hemert
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Author: J.I. van Hemert <jvhemert@cs.leidenuniv.nl>
 *
 * Last Revision: 13-Mar-1999 17:22 by jvhemert
 *
 */

#include "Mondriaan.h"

#include "Error.h"
#include "Crossover.h"
#include "Mutation.h"
#include "Evaluate.h"
#include "Reproduction.h"
#include "ParentSelection.h"
#include "SurvivorsSelection.h"

#include "ui/gladesig.h"
#include "ui/draw.h"

extern GdkPixmap * pixmaps[NUMBER_OF_CANVAS];

Mondriaan::Mondriaan
(
	Configuration const & _configuration
)
:
	configuration(_configuration),
	random(_configuration.AsUnsignedInt("RandomSeed")),
	initialization(random, configuration, configuration.AsUnsignedInt("GenotypeLength")),
	ea(configuration, initialization, evaluate),
	parentselection(configuration.AsUnsignedInt("ParentSelectionSize"), random, configuration.AsUnsignedInt("TournamentSize")),
	crossover(random),
	mutation(random, configuration),
	reproduction(crossover, mutation, evaluate),
	survivorsselection()
{

	for (unsigned int i = 0; i < configuration.AsUnsignedInt("PopulationSize"); ++i)
	{
		 Canvas * canvas = new Canvas(pixmaps[i], Coordinates(configuration.AsUnsignedInt("CanvasSize"), configuration.AsUnsignedInt("CanvasSize")));
		 screen.push_back(canvas);
	}

	list<Canvas *>::iterator c = screen.begin();
	for (
			vector<Individual<unsigned int, Data> >::iterator i = ea.GetPopulation().Pool().begin();
			i != ea.GetPopulation().Pool().end();
			++i
		)
	{
		(*c)->Clear();
		i->data.Draw(*(*c));
		++c;
	}
	draw_draw_screen();
	
} // Mondriaan


Mondriaan::~Mondriaan
(
)
{
	for (unsigned int i = 0; i < configuration.AsUnsignedInt("PopulationSize"); ++i)
	{
		 Canvas * canvas = screen.front();
		 screen.pop_front();
		 delete canvas;
	}
}

void
Mondriaan::GotoNextGeneration()
{
	// Set fitness values from user input
	unsigned int j = 1;
	for (
			vector<Individual<unsigned int, Data> >::iterator i = ea.GetPopulation().Pool().begin();
			i != ea.GetPopulation().Pool().end();
			++i
		)
	{
		i->fitness = ui_get_hscale_value(j);
		ui_set_hscale_value(j, 0);
		++j;
	}

	try
	{
		ea.GotoNextGeneration(parentselection, reproduction, survivorsselection);
	}
	catch (Error e)
	{
		 e.Handle();
	}


	
	list<Canvas *>::iterator c = screen.begin();
	for (
			vector<Individual<unsigned int, Data> >::iterator i = ea.GetPopulation().Pool().begin();
			i != ea.GetPopulation().Pool().end();
			++i
		)
	{
		(*c)->Clear();
		i->data.Draw(*(*c));
		++c;
	}
	draw_draw_screen();
	
//	cout << evaluate.GetNumberOfFitnessEvaluations() << " " << ea.GetPopulation().GetBestIndividual().GetFitness() << endl;
}

// Eof Mondriaan.cc
