/* 
 * Individual.h - Basic individual template class
 *
 * Copyright (C) 1998 J.I. van Hemert
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Author: J.I. van Hemert <jvhemert@cs.leidenuniv.nl>
 *
 * Last Revision: 10-Mar-1999 21:56 by jvhemert
 *
 */

#ifndef Individual_H
#define Individual_H

#include <iostream>

template <class F, class D>
class Individual
{
	public:

		Individual
		(
			D const & _data,
			F const & _fitness
		)
		:
			fitness(_fitness),
			data(_data),
			ID(UniqueID++)
		{
		};

		Individual
		(
			D const & _data
		)
		:
			fitness(0),
			data(_data),
			ID(UniqueID++)
		{
		};

		~Individual(){};

		friend
		ostream &
		operator<<
		(
			ostream & _ostream,
			Individual const & _individual
		)
		{
			_individual.Print(_ostream);

			return _ostream;
		};

		friend
		bool
		operator<
		(
			Individual const & _individual1,
			Individual const & _individual2
		)
		{
			return (_individual1.fitness < _individual2.fitness);
		};

		F const &
		GetFitness() const
		{
			 return fitness;
		};

		D const &
		GetData() const
		{
			return data;	 
		};
		
		Individual
		(
		)
		:
			fitness(0),
			data(),
			ID(UniqueID++)
		{
		};

		// FIXME: next two should be private and referenced by Mutation, Crossover and Evaluate only. Use friend class, but how?

		F fitness;

		D data;

	protected:

		void
		Print
		(
			ostream & _ostream
		) const
		{
			_ostream << "Id: " << ID << "  Fitness: " << fitness << "  Data: " << data;
			//copy(data.begin(),data.end(),ostream_iterator<D>(_ostream," "));
		};

	private:

		static unsigned long int UniqueID;
		unsigned long int ID;


}; // Individual


template <class F, class D>
unsigned long int Individual<F, D>::UniqueID = 0;

#endif // Individual_H

// Eof Individual.h
