/* 
 * Configuration.h - holds a configuration file read from disk.
 *
 * Copyright (C) 1998 J.I. van Hemert
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Author: J.I. van Hemert <jvhemert@cs.leidenuniv.nl>
 *
 * Last Revision: 10-Feb-1999 11:31 by jvhemert
 *
 */

#ifndef Configuration_H
#define Configuration_H

#include <hash_map>
#include <string>
#include <strstream.h>

#include "Error.h"

class Configuration
{
	public:

		Configuration
		(
			string const & _filename
		);

		~Configuration()
		{
			for (hash_map<const char*, char*, hash<const char*>, eqstr >::const_iterator ii = items.begin(); ii != items.end(); ++ii)
			{
				//FIXME delete ii->first;
				delete ii->second;
			}

		};

		double
		AsDouble
		(
			char const * _item
		) const
		{
			istrstream is(FindItem(_item));
			double i;
			is >> i;

			return i;
		};

		unsigned int
		AsUnsignedInt
		(
			char const * _item
		) const
		{
			istrstream is(FindItem(_item));
			unsigned int i;
			is >> i;

			return i;
		};

		string const
		operator()
		(
			char const * _item
		) const
		{
			return string(FindItem(_item));
		};
		
		
		friend
		ostream &
		operator<<
		(
			ostream & _ostream,
			Configuration const & _configuration
		)
		{
			for (hash_map<const char*, char*, hash<const char*>, eqstr >::const_iterator ii = _configuration.items.begin(); ii != _configuration.items.end(); ++ii)
			{
				_ostream << ii->first << " = " << ii->second << endl;
			}

			return _ostream;
		};
			
		
	protected:

		char const *
		FindItem
		(
			char const * _item
		) const
		{
			hash_map<const char*, char *, hash<const char*> ,eqstr >::const_iterator ii = items.find(_item);

			if (ii == items.end())
			{ 
				throw Error(string("No item called \"") + _item + string ("\" found in the configuration."));
			}
			
			//DEBUG cerr << ii->first << " : " << ii->second << endl;

			return ii->second;
		};
		
	private:

		struct eqstr
		{
			bool operator()(const char* s1, const char* s2) const
			{
				return strcmp(s1, s2) == 0;
			}
		};
		hash_map<const char*, char *, hash<const char*> ,eqstr > items;

}; // Configuration

#endif // Configuration_H

// Eof Configuration.h
