/* 
 * Canvas.cc - A canvas to draw upon. It handles colored squares, vertical lines
 * and horizontal lines.
 *
 * Copyright (C) 1998 J.I. van Hemert
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Author: J.I. van Hemert <jvhemert@cs.leidenuniv.nl>
 *
 * Last Revision: 04-Apr-1999 12:24 by jvhemert
 *
 */

#include "Canvas.h"
#include "ui/draw.h"
#include "ui/gladesig.h"

extern GdkPixmap * pixmaps[NUMBER_OF_CANVAS];


Canvas::Canvas
(
	GdkPixmap *_pixmap,
	Coordinates _size
)
:
	pixmap(_pixmap),
	size(_size)
{
} // Canvas



Canvas::~Canvas
(
)
{
} // ~Canvas



	void 
Canvas::DrawRectangle
(
	Coordinates const & _corner1,
	Coordinates const & _corner2,
	Color const & _color
)
{
	unsigned int x1 = _corner1.x;
	unsigned int x2 = _corner2.x;
	unsigned int y1 = _corner1.y;
	unsigned int y2 = _corner2.y;

	if (_corner1.y > _corner2.y)
	{
		y1 = _corner2.y;
		y2 = _corner1.y;
	}

	if (_corner1.x > _corner2.x)
	{
		x1 = _corner2.x;
		x2 = _corner1.x;
	}


	if (x1 > 0)
	{
		x1 = x1 * scale - 3;
	}
	if (x2 > 0)
	{
		x2 = x2 * scale + 5;
	}
	else
	{
		 x2 = 5;
	}
	if (y1 > 0)
	{
		y1 = y1 * scale - 3;
	}
	if (y2 > 0)
	{
		y2 = y2 * scale + 5;
	}
	else
	{
		 y2 = 5;
	}

	//cerr << x1 << ", " << y1 << ", " << x2 << ", " << y2 << " : " << _color << endl;

	draw_draw_rectangle(pixmap, x1, y1, x2, y2, _color.r, _color.g, _color.b);

} // DrawRectangle



	void 
Canvas::DrawVerticalLine
(
	Coordinates const & _corner1,
	Coordinates const & _corner2,
	Color const & _color
)
{
	if (_corner1.x != _corner2.x)
	{
		 throw Error("Tried to draw a line that is not vertical using Canvas::DrawVerticalLine()");
	}

	unsigned int x1 = _corner1.x;
	unsigned int x2 = _corner2.x;
	unsigned int y1 = _corner1.y;
	unsigned int y2 = _corner2.y;

	if (x1 > 0)
	{
		 x1 = x1 * scale - 5;
	}
	if (x2 > 0)
	{
		 x2 = x2 * scale - 5;
	}
	if (y1 > 0)
	{
		 y1 = y1 * scale - 5;
	}
	if (y2 > 0)
	{
		 y2 = y2 * scale - 4;
	}
	draw_draw_line(pixmap, x1, y1, x2, y2, _color.r, _color.g, _color.b);
	draw_draw_line(pixmap, x1 + 1, y1, x2 + 1, y2, _color.r, _color.g, _color.b);
	
	//draw_draw_line(pixmap, 5 + _corner1.x * scale, _corner1.y * scale, 5 + _corner2.x * scale, _corner2.y * scale + 2, _color.r, _color.g, _color.b);
	//draw_draw_line(pixmap, 6 + _corner1.x * scale, _corner1.y * scale, 6 + _corner2.x * scale, _corner2.y * scale + 2, _color.r, _color.g, _color.b);

} // DrawVerticalLine



	void 
Canvas::DrawHorizontalLine
(
	Coordinates const & _corner1,
	Coordinates const & _corner2,
	Color const & _color
)
{
	if (_corner1.y != _corner2.y)
	{
		 throw Error("Tried to draw a line that is not horizontal using Canvas::DrawHorizontalLine()");
	}

	unsigned int x1 = _corner1.x;
	unsigned int x2 = _corner2.x;
	unsigned int y1 = _corner1.y;
	unsigned int y2 = _corner2.y;

	if (x1 > 0)
	{
		 x1 = x1 * scale - 5;
	}
	if (x2 > 0)
	{
		 x2 = x2 * scale - 4;
	}
	if (y1 > 0)
	{
		 y1 = y1 * scale - 5;
	}
	if (y2 > 0)
	{
		 y2 = y2 * scale - 5;
	}
	draw_draw_line(pixmap, x1, y1, x2, y2, _color.r, _color.g, _color.b);
	draw_draw_line(pixmap, x1, y1 + 1, x2, y2 + 1, _color.r, _color.g, _color.b);

	//draw_draw_line(pixmap, _corner1.x * scale, 5 + _corner1.y * scale, _corner2.x * scale + 2, 5 + _corner2.y * scale, _color.r, _color.g, _color.b);
	//draw_draw_line(pixmap, _corner1.x * scale, 6 + _corner1.y * scale, _corner2.x * scale + 2, 6 + _corner2.y * scale, _color.r, _color.g, _color.b);

} // DrawHorizontalLine



	void 
Canvas::Clear
(
)
{
	DrawRectangle(Coordinates(0, 0), Coordinates(size.x, size.y), Color::white);
	
} // Clear



unsigned int Canvas::scale = 10;

Color Color::black(0, 0, 0);
Color Color::white(255, 255, 255);

Color Color::red(255, 0, 0);
Color Color::green(0, 255, 0);
Color Color::blue(0, 0, 255);

Color Color::cyan(0, 255, 255);
Color Color::magenta(255, 0, 255);
Color Color::yellow(255, 255, 0);

// Eof Canvas.cc
